/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.kinetics.crafter;

import com.zurrtum.create.catnip.data.Pair;
import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.catnip.math.Pointing;
import com.zurrtum.create.catnip.theme.Color;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.AllSpriteShifts;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.client.content.kinetics.base.KineticBlockEntityRenderer;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationManager;
import com.zurrtum.create.client.flywheel.lib.model.baked.PartialModel;
import com.zurrtum.create.content.kinetics.base.HorizontalKineticBlock;
import com.zurrtum.create.content.kinetics.crafter.MechanicalCrafterBlock;
import com.zurrtum.create.content.kinetics.crafter.MechanicalCrafterBlockEntity;
import com.zurrtum.create.content.kinetics.crafter.RecipeGridHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10442;
import net.minecraft.class_10444;
import net.minecraft.class_11659;
import net.minecraft.class_11683;
import net.minecraft.class_11954;
import net.minecraft.class_12075;
import net.minecraft.class_12249;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4608;
import net.minecraft.class_5614;
import net.minecraft.class_7833;
import net.minecraft.class_811;
import net.minecraft.class_827;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionfc;

@Environment(value=EnvType.CLIENT)
public class MechanicalCrafterRenderer
implements class_827<MechanicalCrafterBlockEntity, MechanicalCrafterRenderState> {
    protected final class_10442 itemModelManager;

    public MechanicalCrafterRenderer(class_5614.class_5615 context) {
        this.itemModelManager = context.comp_4536();
    }

    public MechanicalCrafterRenderState createRenderState() {
        return new MechanicalCrafterRenderState();
    }

    public void extractRenderState(MechanicalCrafterBlockEntity be, MechanicalCrafterRenderState state, float tickProgress, class_243 cameraPos, @Nullable class_11683.class_11792 crumblingOverlay) {
        class_2350 targetDirection;
        class_11954.method_74399((class_2586)be, (class_11954)state, (class_11683.class_11792)crumblingOverlay);
        class_1937 world = be.method_10997();
        MechanicalCrafterBlockEntity.Phase phase = be.phase;
        state.item = MechanicalCrafterRenderer.createItemState(this.itemModelManager, be, world, state.field_62674, phase, tickProgress);
        class_2350 facing = (class_2350)state.field_62674.method_11654(HorizontalKineticBlock.HORIZONTAL_FACING);
        float yRot = AngleHelper.horizontalAngle(facing);
        if (state.item != null) {
            class_243 vec = class_243.method_24954((class_2382)facing.method_62675()).method_1021(0.58).method_1031(0.5, 0.5, 0.5);
            if (phase == MechanicalCrafterBlockEntity.Phase.EXPORTING) {
                targetDirection = MechanicalCrafterBlock.getTargetDirection(state.field_62674);
                float progress = class_3532.method_15363((float)(((float)(1000 - be.countDown) + (float)be.getCountDownSpeed() * tickProgress) / 1000.0f), (float)0.0f, (float)1.0f);
                vec = vec.method_1019(class_243.method_24954((class_2382)targetDirection.method_62675()).method_1021((double)(progress * 0.75f)));
            }
            state.offset = vec;
            state.yRot = (float)Math.PI / 180 * yRot;
        }
        state.layer = class_12249.method_75965();
        if (!VisualizationManager.supportsVisualization((class_1936)world)) {
            state.cogwheel = CogwheelRenderState.create(be, state.field_62674, state.field_62673, facing);
        }
        float xRot = ((Pointing)((Object)state.field_62674.method_11654(MechanicalCrafterBlock.POINTING))).getXRotation();
        state.upRot = (float)((double)((yRot + 90.0f) / 180.0f) * Math.PI);
        state.eastRot = (float)((double)(xRot / 180.0f) * Math.PI);
        if ((be.covered || phase != MechanicalCrafterBlockEntity.Phase.IDLE) && phase != MechanicalCrafterBlockEntity.Phase.CRAFTING && phase != MechanicalCrafterBlockEntity.Phase.INSERTING) {
            state.lid = CachedBuffers.partial(AllPartialModels.MECHANICAL_CRAFTER_LID, state.field_62674);
        }
        if (MechanicalCrafterBlock.isValidTarget(world, state.field_62673.method_10093(targetDirection = MechanicalCrafterBlock.getTargetDirection(state.field_62674)), state.field_62674)) {
            state.belt = CachedBuffers.partial(AllPartialModels.MECHANICAL_CRAFTER_BELT, state.field_62674);
            state.frame = CachedBuffers.partial(AllPartialModels.MECHANICAL_CRAFTER_BELT_FRAME, state.field_62674);
            if (phase == MechanicalCrafterBlockEntity.Phase.EXPORTING) {
                int textureIndex = (int)((float)be.getCountDownSpeed() / 128.0f * (float)AnimationTickHolder.getTicks());
                state.beltScroll = (float)(textureIndex % 4) / 4.0f;
            }
        } else {
            state.arrow = CachedBuffers.partial(AllPartialModels.MECHANICAL_CRAFTER_ARROW, state.field_62674);
        }
    }

    public static MechanicalCrafterItemRenderState createItemState(class_10442 itemModelManager, MechanicalCrafterBlockEntity be, class_1937 world, class_2680 blockState, MechanicalCrafterBlockEntity.Phase phase, float tickProgress) {
        if (phase == MechanicalCrafterBlockEntity.Phase.IDLE) {
            return MechanicalCrafterSingleItemRenderState.create(itemModelManager, be, world);
        }
        if (phase == MechanicalCrafterBlockEntity.Phase.CRAFTING) {
            return MechanicalCrafterCraftingItemRenderState.create(itemModelManager, be, world, tickProgress);
        }
        return MechanicalCrafterPhaseItemRenderState.create(itemModelManager, be, world, blockState, phase);
    }

    public void submit(MechanicalCrafterRenderState state, class_4587 matrices, class_11659 queue, class_12075 cameraState) {
        queue.method_73483(matrices, state.layer, (class_11659.class_11660)state);
        if (state.item != null) {
            matrices.method_61958(state.offset);
            matrices.method_22905(0.5f, 0.5f, 0.5f);
            matrices.method_22907((Quaternionfc)class_7833.field_40716.rotation(state.yRot));
            state.item.render(queue, matrices, state.field_62676);
        }
    }

    private SuperByteBuffer renderAndTransform(PartialModel renderBlock, class_2680 crafterState) {
        SuperByteBuffer buffer = CachedBuffers.partial(renderBlock, crafterState);
        float xRot = ((Pointing)((Object)crafterState.method_11654(MechanicalCrafterBlock.POINTING))).getXRotation();
        float yRot = AngleHelper.horizontalAngle((class_2350)crafterState.method_11654(HorizontalKineticBlock.HORIZONTAL_FACING));
        buffer.rotateCentered((float)((double)((yRot + 90.0f) / 180.0f) * Math.PI), class_2350.field_11036);
        buffer.rotateCentered((float)((double)(xRot / 180.0f) * Math.PI), class_2350.field_11034);
        return buffer;
    }

    @Environment(value=EnvType.CLIENT)
    public static class MechanicalCrafterRenderState
    extends class_11954
    implements class_11659.class_11660 {
        public class_243 offset;
        public float yRot;
        public MechanicalCrafterItemRenderState item;
        public class_1921 layer;
        public CogwheelRenderState cogwheel;
        public float upRot;
        public float eastRot;
        public SuperByteBuffer lid;
        public SuperByteBuffer belt;
        public SuperByteBuffer frame;
        public float beltScroll;
        public SuperByteBuffer arrow;

        public void render(class_4587.class_4665 matricesEntry, class_4588 vertexConsumer) {
            if (this.cogwheel != null) {
                this.cogwheel.render(matricesEntry, vertexConsumer, this.field_62676);
            }
            if (this.lid != null) {
                ((SuperByteBuffer)((SuperByteBuffer)this.lid.rotateCentered(this.upRot, class_2350.field_11036)).rotateCentered(this.eastRot, class_2350.field_11034)).light(this.field_62676).renderInto(matricesEntry, vertexConsumer);
            }
            if (this.belt != null) {
                ((SuperByteBuffer)this.belt.rotateCentered(this.upRot, class_2350.field_11036)).rotateCentered(this.eastRot, class_2350.field_11034);
                if (this.beltScroll != 0.0f) {
                    this.belt.shiftUVtoSheet(AllSpriteShifts.CRAFTER_THINGIES, this.beltScroll, 0.0f, 1);
                }
                this.belt.light(this.field_62676).renderInto(matricesEntry, vertexConsumer);
                ((SuperByteBuffer)((SuperByteBuffer)this.frame.rotateCentered(this.upRot, class_2350.field_11036)).rotateCentered(this.eastRot, class_2350.field_11034)).light(this.field_62676).renderInto(matricesEntry, vertexConsumer);
            } else {
                ((SuperByteBuffer)((SuperByteBuffer)this.arrow.rotateCentered(this.upRot, class_2350.field_11036)).rotateCentered(this.eastRot, class_2350.field_11034)).light(this.field_62676).renderInto(matricesEntry, vertexConsumer);
            }
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static interface MechanicalCrafterItemRenderState {
        public void render(class_11659 var1, class_4587 var2, int var3);
    }

    @Environment(value=EnvType.CLIENT)
    public record CogwheelRenderState(SuperByteBuffer cogwheel, float angle, class_2350 direction, Color color, float upAngle) {
        public static CogwheelRenderState create(MechanicalCrafterBlockEntity be, class_2680 blockState, class_2338 pos, class_2350 facing) {
            SuperByteBuffer model = CachedBuffers.partial(AllPartialModels.SHAFTLESS_COGWHEEL, blockState);
            class_2350.class_2351 axis = facing.method_10166();
            float angle = KineticBlockEntityRenderer.getAngleForBe(be, pos, axis);
            class_2350 direction = class_2350.method_10169((class_2350.class_2351)axis, (class_2350.class_2352)class_2350.class_2352.field_11056);
            float upAngle = axis != class_2350.class_2351.field_11048 ? 0.0f : 1.5707964f;
            Color color = KineticBlockEntityRenderer.getColor(be);
            return new CogwheelRenderState(model, angle, direction, color, upAngle);
        }

        public void render(class_4587.class_4665 matricesEntry, class_4588 vertexConsumer, int light) {
            ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)this.cogwheel.rotateCentered(this.angle, this.direction)).rotateCentered(this.upAngle, class_2350.field_11036)).rotateCentered(1.5707964f, class_2350.field_11034)).light(light).renderInto(matricesEntry, vertexConsumer);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public record MechanicalCrafterSingleItemRenderState(float offset, float yRot, class_10444 state) implements MechanicalCrafterItemRenderState
    {
        public static MechanicalCrafterSingleItemRenderState create(class_10442 itemModelManager, MechanicalCrafterBlockEntity be, class_1937 world) {
            class_1799 stack = be.getInventory().getStack();
            if (stack.method_7960()) {
                return null;
            }
            float offset = -0.00390625f;
            float yRot = (float)Math.PI;
            class_10444 state = new class_10444();
            state.field_55337 = class_811.field_4319;
            itemModelManager.method_65596(state, stack, state.field_55337, world, null, 0);
            return new MechanicalCrafterSingleItemRenderState(offset, yRot, state);
        }

        @Override
        public void render(class_11659 queue, class_4587 ms, int light) {
            ms.method_22903();
            ms.method_46416(0.0f, 0.0f, this.offset);
            ms.method_22907((Quaternionfc)class_7833.field_40716.rotation(this.yRot));
            this.state.method_65604(ms, queue, light, class_4608.field_21444, 0);
            ms.method_22909();
        }
    }

    @Environment(value=EnvType.CLIENT)
    public record MechanicalCrafterCraftingItemRenderState(float scale, class_243 centering, List<GridItemRenderState> before, float yRot, float zRot, float upScaling, float downScaling, List<class_10444> states) implements MechanicalCrafterItemRenderState
    {
        public static MechanicalCrafterCraftingItemRenderState create(class_10442 itemModelManager, MechanicalCrafterBlockEntity be, class_1937 world, float tickProgress) {
            ArrayList states;
            float zRot;
            float upScaling;
            float downScaling;
            ArrayList before;
            class_243 centering;
            float scale;
            RecipeGridHandler.GroupedItems items = be.groupedItemsBeforeCraft;
            boolean beforeEmpty = items.grid.isEmpty();
            boolean itemsEmpty = be.groupedItems.grid.isEmpty();
            if (beforeEmpty && itemsEmpty) {
                return null;
            }
            float yRot = (float)Math.PI;
            float value = (float)be.countDown - (float)be.getCountDownSpeed() * tickProgress;
            if (beforeEmpty) {
                scale = 0.0f;
                centering = null;
                before = null;
            } else {
                items.calcStats();
                float progress = class_3532.method_15363((float)((2000.0f - value) / 1000.0f), (float)0.0f, (float)1.0f);
                float earlyProgress = class_3532.method_15363((float)(progress * 2.0f), (float)0.0f, (float)1.0f);
                scale = 1.0f - class_3532.method_15363((float)(progress * 2.0f - 1.0f), (float)0.0f, (float)1.0f);
                centering = new class_243((double)((float)(-items.minX) + (float)(-items.width + 1) / 2.0f), (double)((float)(-items.minY) + (float)(-items.height + 1) / 2.0f), 0.0).method_1021((double)earlyProgress).method_18805(0.5, 0.5, 1.0);
                float distance = 0.5f + (-4.0f * (progress - 0.5f) * (progress - 0.5f) + 1.0f) * 0.25f;
                boolean onlyRenderFirst = be.countDown < 1000;
                before = new ArrayList(items.grid.size());
                items.grid.forEach((pair, stack) -> {
                    if (onlyRenderFirst && ((Integer)pair.getFirst() != 0 || (Integer)pair.getSecond() != 0)) {
                        return;
                    }
                    int x = (Integer)pair.getFirst();
                    int y = (Integer)pair.getSecond();
                    float offsetX = (float)x * distance;
                    float offsetY = (float)y * distance;
                    float offsetZ = (float)(x + y * 3) / 1024.0f;
                    class_10444 state = new class_10444();
                    state.field_55337 = class_811.field_4319;
                    itemModelManager.method_65596(state, stack, state.field_55337, world, null, 0);
                    before.add(new GridItemRenderState(state, offsetX, offsetY, offsetZ));
                });
            }
            if (itemsEmpty) {
                downScaling = 0.0f;
                upScaling = 0.0f;
                zRot = 0.0f;
                states = null;
            } else {
                float progress = class_3532.method_15363((float)((1000.0f - value) / 1000.0f), (float)0.0f, (float)1.0f);
                float earlyProgress = class_3532.method_15363((float)(progress * 2.0f), (float)0.0f, (float)1.0f);
                zRot = (float)Math.PI / 180 * (earlyProgress * 2.0f * 360.0f);
                upScaling = earlyProgress * 1.125f;
                downScaling = 1.0f + (1.0f - class_3532.method_15363((float)(progress * 2.0f - 1.0f), (float)0.0f, (float)1.0f)) * 0.125f;
                items = be.groupedItems;
                states = new ArrayList(items.grid.size());
                items.grid.forEach((pair, stack) -> {
                    if ((Integer)pair.getFirst() != 0 || (Integer)pair.getSecond() != 0) {
                        return;
                    }
                    class_10444 state = new class_10444();
                    state.field_55337 = class_811.field_4319;
                    itemModelManager.method_65596(state, stack, state.field_55337, world, null, 0);
                    states.add(state);
                });
            }
            return new MechanicalCrafterCraftingItemRenderState(scale, centering, before, yRot, zRot, upScaling, downScaling, states);
        }

        @Override
        public void render(class_11659 queue, class_4587 ms, int light) {
            if (this.before != null) {
                ms.method_22903();
                ms.method_22905(this.scale, this.scale, this.scale);
                ms.method_61958(this.centering);
                for (GridItemRenderState gridItemRenderState : this.before) {
                    gridItemRenderState.render(queue, ms, this.yRot, light);
                }
                ms.method_22909();
            }
            if (this.states != null) {
                ms.method_22907((Quaternionfc)class_7833.field_40718.rotation(this.zRot));
                ms.method_22905(this.upScaling, this.upScaling, this.upScaling);
                ms.method_22905(this.downScaling, this.downScaling, this.downScaling);
                for (class_10444 class_104442 : this.states) {
                    ms.method_22903();
                    ms.method_22907((Quaternionfc)class_7833.field_40716.rotation(this.yRot));
                    class_104442.method_65604(ms, queue, light, class_4608.field_21444, 0);
                    ms.method_22909();
                }
            }
        }
    }

    @Environment(value=EnvType.CLIENT)
    public record MechanicalCrafterPhaseItemRenderState(List<GridItemRenderState> states, float yRot) implements MechanicalCrafterItemRenderState
    {
        public static MechanicalCrafterPhaseItemRenderState create(class_10442 itemModelManager, MechanicalCrafterBlockEntity be, class_1937 world, class_2680 blockState, MechanicalCrafterBlockEntity.Phase phase) {
            Map<Pair<Integer, Integer>, class_1799> grid = be.groupedItems.grid;
            if (grid.isEmpty()) {
                return null;
            }
            float distance = 0.5f;
            boolean onlyRenderFirst = phase == MechanicalCrafterBlockEntity.Phase.INSERTING;
            boolean isExporting = phase == MechanicalCrafterBlockEntity.Phase.EXPORTING && blockState.method_28498(MechanicalCrafterBlock.POINTING);
            Pointing pointing = isExporting ? (Pointing)((Object)blockState.method_11654(MechanicalCrafterBlock.POINTING)) : null;
            float yRot = (float)Math.PI;
            ArrayList<GridItemRenderState> states = new ArrayList<GridItemRenderState>(grid.size());
            grid.forEach((pair, stack) -> {
                if (onlyRenderFirst && ((Integer)pair.getFirst() != 0 || (Integer)pair.getSecond() != 0)) {
                    return;
                }
                int x = (Integer)pair.getFirst();
                int y = (Integer)pair.getSecond();
                float offsetX = (float)x * distance;
                float offsetY = (float)y * distance;
                int value = x + y * 3;
                if (pointing != null) {
                    switch (pointing) {
                        case UP: {
                            value -= 9;
                            break;
                        }
                        case LEFT: {
                            value += 18;
                            break;
                        }
                        case RIGHT: {
                            value -= 18;
                            break;
                        }
                        case DOWN: {
                            value += 9;
                        }
                    }
                }
                float offsetZ = (float)value / 1024.0f;
                class_10444 state = new class_10444();
                state.field_55337 = class_811.field_4319;
                itemModelManager.method_65596(state, stack, state.field_55337, world, null, 0);
                states.add(new GridItemRenderState(state, offsetX, offsetY, offsetZ));
            });
            return new MechanicalCrafterPhaseItemRenderState(states, yRot);
        }

        @Override
        public void render(class_11659 queue, class_4587 ms, int light) {
            for (GridItemRenderState state : this.states) {
                state.render(queue, ms, this.yRot, light);
            }
        }
    }

    @Environment(value=EnvType.CLIENT)
    public record GridItemRenderState(class_10444 state, float offsetX, float offsetY, float offsetZ) {
        public void render(class_11659 queue, class_4587 ms, float yRot, int light) {
            ms.method_22903();
            ms.method_46416(this.offsetX, this.offsetY, 0.0f);
            ms.method_22907((Quaternionfc)class_7833.field_40716.rotation(yRot));
            ms.method_46416(0.0f, 0.0f, this.offsetZ);
            this.state.method_65604(ms, queue, light, class_4608.field_21444, 0);
            ms.method_22909();
        }
    }
}

